﻿//////////////////////////////////////////////
// ComplexEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class CompositorNode ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "ComplexEffectType.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ComplexEffect
	{
		public :

			// Constructor, destructor
			ComplexEffect (COMPLEX_EFFECT_TYPE type) noexcept ;
			virtual ~ComplexEffect () ;

			// Getters
			nkMemory::StringView getName () const ;
			nkGraphics::CompositorNode* getCompositorNode () const ;
			COMPLEX_EFFECT_TYPE getType () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setCompositorNode (nkGraphics::CompositorNode* value) ;

			// Load
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;

		protected :

			// Attributes
			// Name for identification
			nkMemory::String _name ;

			// CompositorNode we reference
			nkGraphics::CompositorNode* _compositorNode ;

			// Underlying type
			COMPLEX_EFFECT_TYPE _type ;
	} ;
}